package race;

import java.util.ArrayList;

import race.operations.ArrayListSortingWithBubbleSort;
import race.operations.ArrayListSortingWithCollectionsSort;

/**
 * This Interface is meant to represents any kind of operation executed over a
 * certain set of data. The set initialization is realized by translating a list
 * of pseudo-random integer elements in a set of proper data
 * 
 * @author simone
 * @version 1.2
 * @since 1.0
 * @see ListAdder, {@link ArrayListSortingWithCollectionsSort},
 *      {@link ArrayListSortingWithBubbleSort}
 *
 */
public interface Operation {

	/**
	 * Execute this operation
	 * 
	 */
	public void operate();

	/**
	 * Initialize the operation's data
	 * 
	 * @param randomSeem
	 *            : a list of random integers, used as a seem for operation's
	 *            data set
	 */
	public void initializeOperationData(ArrayList<Integer> randomSeem);
}
